/*
 * Decompiled with CFR 0.152.
 */
package jace.ui;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JLabel;

public class OutlinedLabel
extends JLabel {
    public OutlinedLabel(Icon image) {
        super(image);
    }

    public OutlinedLabel(String text) {
        super(text);
    }

    public OutlinedLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
    }

    public OutlinedLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
    }

    public OutlinedLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
    }

    @Override
    public void paint(Graphics g) {
        String text = this.getText();
        Graphics2D gg = (Graphics2D)g;
        this.getIcon().paintIcon(this, g, 0, 0);
        int width = this.getWidth();
        int height = this.getHeight();
        TextLayout layout = new TextLayout(text, this.getFont(), ((Graphics2D)g).getFontRenderContext());
        Shape shape = layout.getOutline(null);
        int x = (int)(((double)width - layout.getBounds().getWidth()) / 2.0);
        int y = (int)(((double)height - layout.getBounds().getHeight() + (double)layout.getAscent()) / 2.0 + (double)layout.getDescent());
        AffineTransform shift = AffineTransform.getTranslateInstance(x, y);
        Shape shp = shift.createTransformedShape(shape);
        gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gg.setColor(this.getBackground());
        gg.setStroke(new BasicStroke(3.0f));
        gg.draw(shp);
        gg.setColor(this.getForeground());
        gg.fill(shp);
    }
}

